function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_nonopec_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(64, 1);
residual(1) = T(31)+T(34)+params(22)*y(111)-y(77);
residual(2) = T(26)*(-exp(y(23)))+y(69)*(-(T(30)*params(4)*exp(y(23)*params(4))))+exp(y(23))*y(59)+params(22)*y(113)-y(79);
residual(3) = y(68)*(-(T(29)*params(4)*exp(y(24)*params(4))))+y(64)*y(35)*T(29)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1))+exp(y(24))*y(59)+params(22)*y(112)-y(78);
residual(4) = T(26)*T(35)+y(72)*(-exp(y(25)))+exp(y(25))*y(71)+params(22)*y(115)-y(81);
residual(5) = y(72)*(-exp(y(26)))+exp(y(26))*y(70)+params(22)*y(114)-y(80);
residual(6) = T(37);
residual(7) = T(39);
residual(8) = T(40);
residual(9) = T(41);
residual(10) = T(43)+params(22)*y(110)*(-exp(y(31)));
residual(11) = T(38)+y(65)*T(44)+T(47)+params(22)*y(101)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(48);
residual(12) = exp(y(33))*y(58);
residual(13) = y(63)*(-params(7))+y(62)+T(32)*y(18)*(-(T(24)*(1-exp(y(11)-y(46)))))+T(32)*y(20)*T(24)*exp(params(5)*(-y(46)));
residual(14) = params(4)*exp(y(24)*(params(4)-1))*T(29)*y(64)+y(63)+T(32)*y(19)*(-(T(24)*(1-params(7))));
residual(15) = T(8)*y(72)+y(55)*(-(params(11)*T(12)*T(49)))+y(54)*(-(params(11)*T(50)*T(51)));
residual(16) = y(59)*(-exp(y(37)))+y(57)*(-(T(5)*T(19)*T(16)*T(53)))+y(56)*(-(T(17)*T(3)*T(16)*T(54)))+y(55)*(-(T(14)*params(11)*T(52)))+exp(y(37))*y(54)+params(22)*y(116)-y(82);
residual(17) = T(20)*y(59)+params(22)*y(97)*(-(T(61)*T(64)))+params(22)*y(98)*(-(T(65)*(T(57)*T(67)*T(68)+T(58)*T(67)*T(70))))+params(22)*y(99)*T(74)+params(22)*y(100)*(-(exp((1-params(3))*y(90))*exp(T(1)*y(94))*params(3)*exp(params(3)*y(38))))+params(22)*y(101)*(-(T(20)*(1-params(10))));
residual(18) = (T(35)-exp(y(23)))*T(78)+y(61)*(-(params(1)*T(78)/T(28)))+T(4)*y(60)+y(58)*T(80)+y(57)*T(84)+y(56)*T(86)+y(54)*(-(T(51)*T(88)))+params(22)*y(102)*(-((-(T(78)*T(90)))/(T(26)*T(26))));
residual(19) = (T(35)-exp(y(23)))*T(91)+y(61)*T(92)+exp(y(40))*y(59)+params(22)*y(102)*(-((-(T(90)*T(91)))/(T(26)*T(26))));
residual(20) = exp(y(41))*y(57)+T(32)*y(17)*(-(exp(y(41))*T(24)));
residual(21) = y(60)*(-(T(21)*T(93)))+exp(y(42))*y(56);
residual(22) = T(96);
residual(23) = y(75)+params(22)*y(109)*(-params(15))+y(58)*(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+y(57)*(-(T(5)*T(19)*T(16)*T(97)))+y(56)*(-(T(17)*T(3)*T(16)*T(98)))+y(54)*(-(T(51)*T(100)))+T(101)*(-params(16))*y(117);
residual(24) = T(104)+y(73)+T(108);
residual(25) = y(74)+y(70)*T(109)+y(66)*T(110)+T(114);
residual(26) = y(77);
residual(27) = y(78);
residual(28) = y(79);
residual(29) = y(80);
residual(30) = y(81);
residual(31) = y(82);
residual(32) = T(26)*T(115)+exp(y(53))*y(76);
residual(33) = exp(y(37))-T(9)^T(10);
residual(34) = exp(y(22))-params(11)*T(12)*T(14);
residual(35) = exp(y(42))-T(3)*T(15)*T(16)*T(17);
residual(36) = exp(y(41))-T(5)*T(16)*T(18)*T(19);
residual(37) = exp(y(33))-exp(T(1)*y(44))*exp(y(13)*params(3))*exp(y(39)*(1-params(3)));
residual(38) = exp(y(40))+T(20)+exp(y(24))+exp(y(23))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6))-(exp(y(37))+exp(y(13))*(1-params(10)));
residual(39) = T(4)-T(21)*exp(y(42))^T(22);
residual(40) = 1-T(23)*(1+exp(y(92))-params(10));
residual(41) = T(24)-params(1)*T(26)/T(28);
residual(42) = y(34)-T(23)*(exp(y(32)-y(96))*exp(y(85))+(1-exp(y(32)-y(96)))*y(86)-params(6)*exp(params(5)*(y(32)-y(96))));
residual(43) = y(35)-(y(34)*params(7)+T(23)*(1-params(7))*y(87));
residual(44) = y(35)*params(4)*exp(y(24)*(params(4)-1))*T(29)-1;
residual(45) = T(116);
residual(46) = exp(y(28))-(exp(y(7))*(1-exp(y(11)-y(46)))+params(7)*exp(y(30)));
residual(47) = exp(y(27))-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))+params(7)*exp(y(29)));
residual(48) = exp(y(30))-((1-params(7))*exp(y(9))+T(29)*exp(y(24)*params(4)));
residual(49) = exp(y(29))-((1-params(7))*exp(y(8))+exp(y(23)*params(4))*T(30));
residual(50) = exp(y(26))-exp(y(7))*exp(y(11)-y(46));
residual(51) = exp(y(25))-exp(y(6))*exp((-y(45)))*exp(y(10));
residual(52) = T(8)-(exp(y(26))+exp(y(25)));
residual(53) = y(45)-x(it_, 1);
residual(54) = y(46)-x(it_, 3);
residual(55) = y(44)-(x(it_, 2)+params(15)*y(16)+params(16)*y(21));
residual(56) = exp(y(53))-exp(y(10));
residual(57) = y(47)-(y(22)-y(1));
residual(58) = y(48)-(y(24)-y(3));
residual(59) = y(49)-(y(23)-y(2));
residual(60) = y(50)-(y(26)-y(5));
residual(61) = y(51)-(y(25)-y(4));
residual(62) = y(52)-(y(37)-y(12));
lhs = y(83);
rhs = y(109);
residual(63) = lhs - rhs;
lhs = y(84);
rhs = y(16);
residual(64) = lhs - rhs;

end
